/*  Ersetzt die vorhandenen Einträge der Tabelle resource_requirement_option des gegebenen AG mit der gegebenen Ressourcen-ID.

    Es werden nur Einträge ersetzt, welche den gleichen Kontext haben, wie die Zielressource.
    Dabei werden vorhandene Kopfkostenstellen mit behandelt und ggf. auch die damit verbunden Einträge für diese ersetzt.
*/
SELECT tsystem.function__drop_by_regex( 'ab2__resource_requirement_options__ab2__replace', _commit => true ); -- Alter Funktionsname
--
SELECT tsystem.function__drop_by_regex( 'ab2__resource_requirement_options__replace', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__resource_requirement_options__replace(
      _ab2_id int,
      _resource_id int,
      _load numeric DEFAULT 1,
      _loglevel int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
  ) RETURNS boolean AS $$
  DECLARE

      _prefix varchar := 'scheduling.ab2__resource_requirement_options__replace -';

      _context text := context
                         FROM scheduling.resource
                        WHERE id = _resource_id;

  BEGIN
      -- Debug
      IF _loglevel >= 4 THEN
          RAISE NOTICE '% a2_id:%, resource_id:%, load:%;', _prefix, _ab2_id, _resource_id, _load;
      END IF;

      -- Sind die übgergbenen Parameter gültig?
      IF (
            _ab2_id IS NULL
        OR _resource_id IS NULL
      ) THEN
          RAISE EXCEPTION 'invalid parameter: _ab2_id: %, _resource_id: %', _ab2_id, _resource_id;
      END IF;

      -- Gibt es die Zielressource?
      IF ( _context IS NULL ) THEN
          RAISE EXCEPTION 'non-existing resource';
      END IF;

      -- remove all previous
      PERFORM scheduling.ab2__resource_requirement_options__remove_all( _ab2_id , _context ); --ab2__resource_requirement_options__remove_all

      -- insert new
      PERFORM scheduling.ab2__resource_requirement_options__add_option( _ab2_id, _resource_id, _load => _load, _loglevel => _loglevel ); --ab2__resource_requirement_options__add_option

      RETURN true;

  END $$ LANGUAGE plpgsql;